#include "pch.h"

int
main(int argc, char **argv) {
    SetConsoleTitle("Mir Crypt v0.2 -- 1PKRyan -- www.lomcn.net/forum -- with thanks to OuYangPlane for testing.");

    std::string file_path;
    if      (argv[1])  file_path = argv[1];
    else if (argv[2])  file_path = argv[2];
    else return -1;

    std::string ext;
    std::string builder;

    auto pos = file_path.rfind('.');
    if (pos != std::string::npos) {
        ext = file_path.substr(pos);

        builder.append(file_path.substr(0, pos));
    }

    BF_KEY key = { 0 };
    char *pszData = "Y8vkFwSacHjCFThh";
    blowfish_set_key(&key, strlen(pszData), (BYTE *)pszData);

    auto file_read = fopen(file_path.c_str(), "rb");

    fseek(file_read, 0, SEEK_END);
    auto size = ftell(file_read);
    fseek(file_read, 0, SEEK_SET);

    std::string buffer;
    buffer.resize(size);

    fread((BYTE *)buffer.c_str(), buffer.size(), sizeof(BYTE), file_read);
    fclose(file_read);

    auto num_blocks = static_cast<size_t>(buffer.size() / BF_BLOCK);

    if (ext.compare(".xml") == 0) {
        builder.append(".dat");

        buffer.erase(std::remove(buffer.begin(), buffer.end(), '\n'), buffer.end());
        buffer.resize((buffer.size() + BF_BLOCK - 1) & -BF_BLOCK);

        for (size_t i = 0; i < num_blocks; i++) {
            auto data = (BYTE *)buffer.c_str() + (i * BF_BLOCK);
            blowfish_encrypt(reinterpret_cast<BF_LONG *>(data), &key);
        }
    } else if (ext.compare(".dat") == 0) {
        builder.append(".xml");

        for (size_t i = 0; i < num_blocks; i++) {
            auto data = (BYTE *)buffer.c_str() + (i * BF_BLOCK);
            blowfish_decrypt(reinterpret_cast<BF_LONG *>(data), &key);
        }
    } else {
        printf("error: unknown extension '%s'.  valid extensions are '.dat' or '.xml'.\n", ext.c_str());
        return -1;
    }

    auto file_write = fopen(builder.c_str(), "wb");
    fwrite((void *)buffer.c_str(), buffer.size(), sizeof(BYTE), file_write);
    fclose(file_write);

    return 0;
}